package com.qq.gdt.action.demo;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;

import com.qq.gdt.action.ActionType;
import com.qq.gdt.action.GDTAction;
import java.util.ArrayList;
import java.util.List;



/**
 * 如果是Android6.0以上的系统，需要处理Android6.0动态权限的兼容问题
 *
 * 这里是一个简单的示例，开发者可以根据自己的情况去适配动态权限
 *
 * 在本示例中：
 * 我们需要在Activity的onResume方法中上报App启动行为
 */
public class GDTActionLauncherActivity extends Activity
    implements View.OnClickListener, AdapterView.OnItemSelectedListener {

  private static final String TAG = GDTActionLauncherActivity.class.getSimpleName();
  Button btnSendStandardAction, btnSendCustomAction, btnOpenDefinePage;
  Spinner spinnerStandardAction;
  ArrayAdapter<String> adapter;
  EditText editCustomAction;
  int spinnerPosition;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.activity_main);
    initViews();
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
      checkAndRequestPermission();
    }
  }

  @Override
  protected void onResume() {
    Log.i(TAG, "onResume");
    super.onResume();
//    上报启动事件
    reportAppStart();
  }

  /**
   * 在onResume方法中，我们要上报App启动行为。
   * SDK内部会计算App退到后台的时间间隔，30秒内调用多次也只会上报一次启动事件。
   * 在Activity的onResume方法中上报App启动行为，是因为当用户按下home键使应用退到后台，再恢复到前台时，可能不会执行onCreate方法。
   */
  private void reportAppStart() {
    GDTAction.logAction(ActionType.START_APP);
  }

  /**
   * ActionSDK建议获得Manifest.permission.READ_PHONE_STATE权限，上报数据会更准确，不强制要求
   * 本示例在onCreate时获取，开发者可以根据自己的情况去适配动态权限，在GDTAction.logAction之前获取即可
   */
  @TargetApi(Build.VERSION_CODES.M)
  private void checkAndRequestPermission() {
    List<String> lackedPermission = new ArrayList<String>();
    if (!(checkSelfPermission(
        Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED)) {
      lackedPermission.add(Manifest.permission.READ_PHONE_STATE);
    }

    if (!(checkSelfPermission(
        Manifest.permission.WRITE_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED)) {
      lackedPermission.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);
    }

    if (lackedPermission.size() != 0) {
      // 请求所缺少的权限，建议获取，不强制
      String[] requestPermissions = new String[lackedPermission.size()];
      lackedPermission.toArray(requestPermissions);
      requestPermissions(requestPermissions, 1024);
    }
  }

  private void initViews() {
    btnSendStandardAction = (Button) findViewById(R.id.send_standard_action);
    btnSendCustomAction = (Button) findViewById(R.id.send_custom_action);
    editCustomAction = (EditText) findViewById(R.id.edit_custom_action);
    btnSendCustomAction.setOnClickListener(this);
    btnSendStandardAction.setOnClickListener(this);
    btnOpenDefinePage = (Button) findViewById(R.id.open_define_page);
    btnOpenDefinePage.setOnClickListener(this);

    findViewById(R.id.exec_start).setOnClickListener(this);
    findViewById(R.id.exec_clickid).setOnClickListener(this);
    findViewById(R.id.exec_channelid).setOnClickListener(this);


    //
    spinnerStandardAction = (Spinner) findViewById(R.id.spinner_standard_action);
    spinnerStandardAction.setOnItemSelectedListener(this);
    List<String> standardActionList = new ArrayList<String>();
    standardActionList.add(ActionType.PAGE_VIEW);
    standardActionList.add(ActionType.REGISTER);
    standardActionList.add(ActionType.VIEW_CONTENT);
    standardActionList.add(ActionType.CONSULT);
    standardActionList.add(ActionType.ADD_TO_CART);
    standardActionList.add(ActionType.PURCHASE);
    standardActionList.add(ActionType.SEARCH);
    standardActionList.add(ActionType.ADD_TO_WISHLIST);
    standardActionList.add(ActionType.INITIATE_CHECKOUT);
    standardActionList.add(ActionType.COMPLETE_ORDER);
    standardActionList.add(ActionType.DOWNLOAD_APP);
    standardActionList.add(ActionType.RATE);
    standardActionList.add(ActionType.RESERVATION);
    standardActionList.add(ActionType.SHARE);
    standardActionList.add(ActionType.APPLY);
    adapter =
        new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, standardActionList);
    adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    spinnerStandardAction.setAdapter(adapter);
  }

  @Override
  public void onClick(View v) {
    String actionType;
    TextView textView = findViewById(R.id.text_clickid);

    switch (v.getId()) {
      case R.id.send_standard_action:
        actionType = adapter.getItem(spinnerPosition);
        GDTAction.logAction(actionType);
        // 如果您需要在上报转化行为的同时，上报行为参数，可以传入一个JSONObject对象
        // 例如，用户发生购物行为时，可以用GDTAction.logAction上报用户的这次行为，并将价格等行为参数一起带上
//        try {
//          JSONObject actionParam = new JSONObject();
//          actionParam.put("value", 6800);
//          actionParam.put("name", "Pixel 2 XL");
//          GDTAction.logAction(actionType, actionParam);
//        } catch (JSONException e) {
//          e.printStackTrace();
//        }
        break;
      case R.id.send_custom_action:
        actionType = editCustomAction.getText().toString();
        if (!TextUtils.isEmpty(actionType)) {
          GDTAction.logAction(actionType);
        }
        break;
      case R.id.open_define_page:
        Intent intent = new Intent(this, GDTActionDefineActivity.class);
        startActivity(intent);
        break;

      case R.id.exec_start:
        GDTAction.start();
        break;
      case R.id.exec_clickid:
        String newText = "clickID：" +  GDTAction.getClickID(this);
        textView.setText(newText);
        break;
      case R.id.exec_channelid:
        String newText2 = "channelID：" +  GDTAction.getChannelID(this);
        textView.setText(newText2);
        break;

      default:
        break;
    }
  }

  @Override
  public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
    spinnerPosition = position;
  }

  @Override
  public void onNothingSelected(AdapterView<?> parent) {

  }

}
