package com.qq.gdt.action.demo;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import com.qq.gdt.action.ActionUtils;

public class GDTActionDefineActivity extends Activity implements View.OnClickListener{

  private Button btnRegister, btnLogin, btnBindAccount, btnQuest, btnCreateRole, btnUpdateLevel,
      btnShare, btnRate, btnViewContent, btnAddToCart, btnCheckout, btnPurchase, btnAddPayment;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.activity_define);
    initViews();
  }

  private void initViews(){
    btnRegister = findViewById(R.id.register);
    btnRegister.setOnClickListener(this);

    btnLogin = findViewById(R.id.login);
    btnLogin.setOnClickListener(this);

    btnBindAccount = findViewById(R.id.bind_account);
    btnBindAccount.setOnClickListener(this);

    btnQuest = findViewById(R.id.quest);
    btnQuest.setOnClickListener(this);

    btnCreateRole = findViewById(R.id.create_role);
    btnCreateRole.setOnClickListener(this);

    btnUpdateLevel = findViewById(R.id.update_level);
    btnUpdateLevel.setOnClickListener(this);

    btnShare = findViewById(R.id.share);
    btnShare.setOnClickListener(this);

    btnRate = findViewById(R.id.rate);
    btnRate.setOnClickListener(this);

    btnViewContent = findViewById(R.id.view_content);
    btnViewContent.setOnClickListener(this);

    btnAddToCart = findViewById(R.id.add_to_cart);
    btnAddToCart.setOnClickListener(this);

    btnCheckout = findViewById(R.id.checkout);
    btnCheckout.setOnClickListener(this);

    btnPurchase = findViewById(R.id.purchase);
    btnPurchase.setOnClickListener(this);

    btnAddPayment = findViewById(R.id.add_payment);
    btnAddPayment.setOnClickListener(this);

  }


  @Override
  public void onClick(View v) {
    if(v == btnRegister){
      ActionUtils.onRegister("WeChat", true);
      Toast.makeText(this, "onRegister: WeChat, true", Toast.LENGTH_LONG).show();
    }else if(v == btnLogin){
      ActionUtils.onLogin("QQ", false);
      Toast.makeText(this, "onLogin: QQ, false", Toast.LENGTH_LONG).show();
    }else if(v == btnBindAccount){
      ActionUtils.onBindAccount("Mobile", true);
      Toast.makeText(this, "onBindAccount: Mobile, true", Toast.LENGTH_LONG).show();
    }else if(v == btnQuest){
      ActionUtils.onQuestFinish("id1", "新手教学","漂移", 1, "漂移练习", true);
      Toast.makeText(this, "onQuestFinish: id1, 新手教学, 漂移, 1, 漂移练习, true", Toast.LENGTH_LONG).show();
    }else if(v == btnCreateRole){
      ActionUtils.onCreateRole("苏妲己");
      Toast.makeText(this, "onCreateRole: 苏妲己", Toast.LENGTH_LONG).show();
    }else if(v == btnUpdateLevel){
      ActionUtils.onUpdateLevel(1024);
      Toast.makeText(this, "onUpdateLevel: 1024", Toast.LENGTH_LONG).show();
    }else if(v == btnShare){
      ActionUtils.onShare("朋友圈", true);
      Toast.makeText(this, "onShare: 朋友圈, true", Toast.LENGTH_LONG).show();
    }else if(v == btnRate){
      ActionUtils.onRateApp(4.5f);
      Toast.makeText(this, "onRateApp: 4.5", Toast.LENGTH_LONG).show();
    }else if(v == btnViewContent){
      ActionUtils.onViewContent("皮肤", "王昭君", "skin-wzj");
      Toast.makeText(this, "onViewContent: 皮肤, 王昭君, skin-wzj", Toast.LENGTH_LONG).show();
    }else if(v == btnAddToCart){
      ActionUtils.onAddToCart("装备", "枪支", "AK47", 2, true);
      Toast.makeText(this, "onAddToCart: 装备, 枪支, AK47, 2, true", Toast.LENGTH_LONG).show();
    }else if(v == btnCheckout){
      ActionUtils.onCheckout("装备", "枪支", "AK47", 2, true, "钻石", "CNY", true);
      Toast.makeText(this, "onCheckout: 装备, 枪支, AK47, 2, true, 钻石, CNY, true", Toast.LENGTH_LONG).show();
    }else if(v == btnPurchase){
      ActionUtils.onPurchase("装备", "枪支", "AK47", 2, "微信支付", "CNY", 648, true);
      Toast.makeText(this, "onPurchase: 装备, 枪支, AK47, 2, 微信支付, CNY, 648, true", Toast.LENGTH_LONG).show();
    }else if(v == btnAddPayment){
      ActionUtils.onAddPaymentChannel("支付宝", true);
      Toast.makeText(this, "onAddPaymentChannel: 支付宝, true", Toast.LENGTH_LONG).show();
    }
  }
}
